﻿using UnityEngine;

public class PortalTeleporter : MonoBehaviour
{
    public Transform player;
    public Transform targetPortal;
    public GameObject targetPortalTunel;
    public GameObject portalTunel;
    
    private bool playerIsOverlapping = false;

    private void Update()
    {
        if (!playerIsOverlapping)
            return;
        
        Vector3 portalToPlayer = player.position - transform.position;
        float dotProduct = Vector3.Dot(transform.up, portalToPlayer);

        if (!(dotProduct < 0f)) return;
        
        // The player has moved across the portal
        float rotationDiff = -Quaternion.Angle(transform.rotation, targetPortal.rotation);
        rotationDiff += 180;
        player.Rotate(Vector3.up, rotationDiff);

        Vector3 positionOffset = Quaternion.Euler(0f, rotationDiff, 0f) * portalToPlayer;
        player.position = targetPortal.position + positionOffset;

        playerIsOverlapping = false;
        targetPortalTunel.SetActive(true);
        portalTunel.SetActive(false);
    }

    private void OnTriggerEnter (Collider other)
    {
        if (other.CompareTag("Player"))
            playerIsOverlapping = true;
    }

    private void OnTriggerExit (Collider other)
    {
        if (other.CompareTag("Player"))
            playerIsOverlapping = false;
    }
}